/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import edu.mit.blocks.codeblockutil.CBorderlessButton;
import edu.mit.blocks.codeblockutil.CHoverScrollPane;
import edu.mit.blocks.codeblockutil.CScrollPane;
import edu.mit.blocks.codeblockutil.Canvas;
import edu.mit.blocks.codeblockutil.Explorer;
import edu.mit.blocks.codeblockutil.ExplorerListener;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.Timer;

public class MagicExplorer
extends JLayeredPane
implements Explorer,
ComponentListener,
FocusListener {
    private static final long serialVersionUID = 328149080294L;
    private List<JComponent> canvases = new ArrayList<JComponent>();
    private JPanel buttonPane;
    private JPanel canvasPane;
    private EnlargerTimer timer;

    public MagicExplorer() {
        this.setLayout(null);
        this.setOpaque(true);
        this.setBackground(Color.GRAY);
        this.timer = new EnlargerTimer();
        this.buttonPane = new JPanel();
        this.buttonPane.setBackground(Color.GRAY);
        this.buttonPane.setLayout(new GridLayout(0, 1));
        this.add((Component)this.buttonPane, JLayeredPane.PALETTE_LAYER);
        this.setLayer(this.buttonPane, JLayeredPane.PALETTE_LAYER, 0);
        this.canvasPane = new JPanel(new BorderLayout());
        this.canvasPane.setBackground(Color.GRAY);
        this.add((Component)this.canvasPane, JLayeredPane.PALETTE_LAYER);
        this.setLayer(this.canvasPane, JLayeredPane.PALETTE_LAYER, 0);
        this.addComponentListener(this);
        this.addFocusListener(this);
    }

    @Override
    public boolean anyCanvasSelected() {
        return false;
    }

    @Override
    public int getSelectedCanvasWidth() {
        return this.canvasPane.getWidth();
    }

    @Override
    public void addListener(ExplorerListener gel) {
    }

    @Override
    public void removeListener(ExplorerListener gel) {
    }

    @Override
    public void setDrawersCard(List<? extends Canvas> items) {
        this.canvases.clear();
        this.buttonPane.removeAll();
        for (int i = 0; i < items.size(); ++i) {
            final int index = i;
            Canvas item = items.get(i);
            CBorderlessButton button = new CBorderlessButton(item.getName());
            CHoverScrollPane scroll = new CHoverScrollPane(item.getJComponent(), CScrollPane.ScrollPolicy.VERTICAL_BAR_AS_NEEDED, CScrollPane.ScrollPolicy.HORIZONTAL_BAR_AS_NEEDED, 18, item.getColor(), Color.darkGray);
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MagicExplorer.this.selectCanvas(index);
                }
            });
            this.canvases.add(scroll);
            this.buttonPane.add(button);
        }
    }

    @Override
    public void selectCanvas(int index) {
        if (index >= 0 && index < this.canvases.size()) {
            JComponent scroll = this.canvases.get(index);
            this.canvasPane.removeAll();
            this.canvasPane.add(scroll);
            this.timer.expand();
            this.requestFocus();
        }
    }

    @Override
    public void reformView() {
        this.buttonPane.setSize(this.getWidth(), this.getHeight());
        this.timer.setWidth(this.getWidth());
        this.timer.shrink();
    }

    @Override
    public JComponent getJComponent() {
        return this;
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.timer.shrink();
    }

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.reformView();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
    }

    @Override
    public void componentShown(ComponentEvent e) {
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }

    private class EnlargerTimer
    implements ActionListener {
        int width;
        private Timer timer = new Timer(50, this);
        private boolean expand = true;

        @Override
        public void actionPerformed(ActionEvent e) {
            if (this.expand) {
                if (MagicExplorer.this.canvasPane.getWidth() < this.width - 25) {
                    MagicExplorer.this.canvasPane.setBounds(0, 0, MagicExplorer.this.canvasPane.getWidth() + 25, MagicExplorer.this.buttonPane.getHeight());
                    MagicExplorer.this.canvasPane.revalidate();
                    MagicExplorer.this.canvasPane.repaint();
                } else {
                    this.timer.stop();
                    MagicExplorer.this.canvasPane.setBounds(0, 0, MagicExplorer.this.buttonPane.getWidth(), MagicExplorer.this.buttonPane.getHeight());
                    MagicExplorer.this.canvasPane.revalidate();
                    MagicExplorer.this.canvasPane.repaint();
                }
            } else if (MagicExplorer.this.canvasPane.getWidth() > 25) {
                MagicExplorer.this.canvasPane.setBounds(0, 0, MagicExplorer.this.canvasPane.getWidth() - 25, MagicExplorer.this.buttonPane.getHeight());
                MagicExplorer.this.canvasPane.revalidate();
                MagicExplorer.this.canvasPane.repaint();
            } else {
                this.timer.stop();
                MagicExplorer.this.canvasPane.setBounds(0, 0, 0, MagicExplorer.this.buttonPane.getHeight());
                MagicExplorer.this.canvasPane.revalidate();
                MagicExplorer.this.canvasPane.repaint();
            }
        }

        public void expand() {
            this.expand = true;
            this.timer.start();
        }

        public void shrink() {
            this.expand = false;
            this.timer.start();
        }

        public void setWidth(int width) {
            this.width = width;
        }
    }
}

