/*
 * Decompiled with CFR 0.152.
 */
package edu.mit.blocks.codeblockutil;

import edu.mit.blocks.codeblockutil.Sound;
import java.io.IOException;
import java.net.URL;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;

public class SoundManager {
    private static boolean enableSound = true;

    public static Sound loadSound(String soundFileName) {
        Clip clip;
        AudioInputStream audioInputStream;
        URL url = SoundManager.class.getResource(soundFileName);
        if (url == null) {
            System.out.println("Could not find resource " + soundFileName);
            return null;
        }
        try {
            audioInputStream = AudioSystem.getAudioInputStream(url);
        }
        catch (UnsupportedAudioFileException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        AudioFormat format = audioInputStream.getFormat();
        try {
            DataLine.Info info = new DataLine.Info(Clip.class, format);
            clip = (Clip)AudioSystem.getLine(info);
            clip.open(audioInputStream);
        }
        catch (LineUnavailableException e) {
            System.out.println("Sorry, sound is not available");
            return null;
        }
        catch (IOException e) {
            return null;
        }
        return new Sound(clip);
    }

    public static void setSoundEnabled(boolean enableSound) {
        SoundManager.enableSound = enableSound;
    }

    public static boolean isSoundEnabled() {
        return enableSound;
    }
}

